#include "iostream"
#include "vector"
#include "string"
#include "algorithm"
using namespace std;
#define forn(i, n) for (int (i) = 0; (i) < (n); (i)++)
#define forndw(i, n) for (int (i) = (n) - 1; (i) >= 0; (i)--)

struct segtree {
    int sz;
    vector<int> tree;
    void add(int v, int x) {
        v += sz;
        while (v != 0) {
            tree[v] += x;
            v /= 2;
        }
    }
    void init(int n) {
        sz = 1;
        while (sz < n)
            sz *= 2;
        tree.assign(sz * 2, 0);
    }
    int getnxt(int v) {
        v += sz;
        int mx = 0;
        while (tree[v] == mx) {
            if (v % 2 == 1) {
                v /= 2;
                mx = tree[v];
            } else {
                v /= 2;
            }
            if (v == 0)
                return 1e7;
        }
        if (v < sz)
            v = v * 2 + 1;
        while (v < sz) {
            if (tree[v * 2])
                v = v * 2;
            else
                v = v * 2 + 1;
        }
        return v - sz;
    }
    int getprv(int v) {
        v += sz;
        int mx = 0;
        while (tree[v] == mx) {
            if (v % 2 == 0) {
                v /= 2;
                mx = tree[v];
            } else {
                v /= 2;
            }
            if (v == 0)
                return -1e7;
        }
        if (v < sz)
            v = v * 2;
        while (v < sz) {
            if (tree[v * 2 + 1])
                v = v * 2 + 1;
            else
                v = v * 2;
        }
        return v - sz;
    }
};
vector<segtree> sgs(20);
int getslv(int crd) {
    //cout << "RS" << crd << '\n';
    vector<pair<int, int> > segi, sg2;
    forn (i, 20) {
        segi.push_back({sgs[i].getprv(crd), sgs[i].getnxt(crd)});
        //cout << "segba " << sgs[i].getprv(crd) << ' ' << sgs[i].getnxt(crd) << '\n';
    }
    sort(segi.begin(), segi.end());
    forn (i, segi.size()) {
        int r = segi[i].second, l = segi[i].first;
        while (!sg2.empty() and sg2.back().first == l)
            sg2.pop_back();
        if (sg2.empty() or sg2.back().second < r)
            sg2.push_back(segi[i]);
    }
    vector<int> rs1(sg2.size() + 1), rs2 = rs1;
    forn (i, sg2.size()) {
        //cout << "segba2 " << sg2[i].first << ' ' << sg2[i].second << '\n';
        rs1[i] = crd - sg2[i].first;
        rs2[i + 1] = sg2[i].second - crd;
    }
    int res = 1e8;
    forn (i, sg2.size() + 1) {
        //cout << "SGB3 " << rs1[i] << ' ' << rs2[i] << '\n';
        res = min(res, min(rs1[i], rs2[i]) * 2 + max(rs1[i], rs2[i]));
    }
    if (res > 1e6)
        return -1;
    return res;
}
void solve() {
    int n;
    cin >> n;
    forn (i, 20) {
        sgs[i].init(n);
    }
    vector<int> a(n);
    forn (i, n) {
        cin >> a[i];
        forn (j, 20) {
            if ((a[i] & (1 << j)) == 0) {
                sgs[j].add(i, 1);
            }
        }
    }
    int q;
    cin >> q;
    forn (i, q) {
        int t;
        cin >> t;
        if (t == 1) {
            int x, b;
            cin >> x >> b;
            x--;
            forn (j, 20) {
                if ((a[x] & (1 << j)) == 0) {
                    sgs[j].add(x, -1);
                }
                if ((b & (1 << j)) == 0) {
                    sgs[j].add(x, 1);
                }
            }
            a[x] = b;
        } else {
            int x;
            cin >> x;
            x--;
            cout << getslv(x) << endl;
        }
    }

}
int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);cout.tie(0);
    int t = 1;
    while (t--) solve();
}